//
// (c) 2021 wesolutions GmbH
// All rights reserved.
//

import QtQml 2.12
import QtQuick 2.12
import QtQuick.Controls 1.4

import wesual.Create 1.0

import wesual.data.Core 1.0

FocusScope {
    id : editor

    readonly property EditContext context : Creator.context
    readonly property bool        busy    : Creator.context.busy
    readonly property int         status  : Stack.status

    property Component toolBar

    enabled : status == Stack.Active

    function createDocument(type) {
        return context.createDocument(type);
    }

    function markActive() {
        context.markActive();
    }

    function markInactive() {
        context.markInactive();
    }

    property string title : ""
}
